#include <iostream>
#include <vector>

std::vector<int> napunjenost_kontejnera(int N, const std::vector<int>& C, const std::vector<int>& A, int Q, const std::vector<int>& k, const std::vector<int>& x) {
    std::vector<int> result = A;

    for (int j = 0; j < Q; ++j) {
        int k_j = k[j] - 1; // clan komsiije
        int x_j = x[j];     // broj zalbi j-tog dana

        for (int t = k_j; t < N; t += 1) {
            int C_k_j = C[t]; // limit kontejnera
            int A_k_j = result[t]; // trenutno stanje kontejnera

            if (A_k_j + x_j > C_k_j) {
                result[t] = C_k_j;
                x_j -= C_k_j - A_k_j;
            } else {
                result[t] += x_j;
                break;
            }
        }
    }

    return result;
}

int main() {
    int N, Q;

    // Ucitaj N
    std::cin >> N;

    // Ucitaj limite kontejnera
    std::vector<int> C(N);
    for (int i = 0; i < N; ++i) {
        std::cin >> C[i];
    }

    // Ucitaj trenutna stanja kontejnera
    std::vector<int> A(N);
    for (int i = 0; i < N; ++i) {
        std::cin >> A[i];
    }

    // Ucitaj broj dana Q
    std::cin >> Q;

    // Ucitaj k i x po danima
    std::vector<int> k(Q), x(Q);
    for (int i = 0; i < Q; ++i) {
        std::cin >> k[i];
    }
    for (int i = 0; i < Q; ++i) {
        std::cin >> x[i];
    }

    // Pozovi fju 
    std::vector<int> result = napunjenost_kontejnera(N, C, A, Q, k, x);

    // Ispis
    for (int value : result) {
        std::cout << value << " ";
    }
    std::cout << std::endl;

    return 0;
}